<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ContentScheduledItem extends Model 
{

    protected $table = 'content_scheduled_item';
    public $timestamps = true;
    protected $fillable = array('content_id', 'component_program_id', 'ordering', 'def', 'date_from', 'date_to', 'time_from', 'time_to', 'shuffle', 'dow');

    public function content()
    {
        return $this->belongsTo('App\Models\Content');
    }

    public function componentProgram()
    {
        return $this->belongsTo('App\Models\ComponentProgram');
    }

}